//
//  RowControlsController.m
//  Nav
//
//  Created by Robert Górczyński on 11-07-06.
//

#import "RowControlsController.h"


@implementation RowControlsController
@synthesize list;
- (IBAction)buttonTapped:(id)sender { 
    UIButton *senderButton = (UIButton *)sender; 
    UITableViewCell *buttonCell = 
	(UITableViewCell *)[senderButton superview]; 
    NSUInteger buttonRow = [[self.tableView 
							 indexPathForCell:buttonCell] row]; 
    NSString *buttonTitle = [list objectAtIndex:buttonRow]; 
    UIAlertView *alert = [[UIAlertView alloc] 
						  initWithTitle:@"Naciśnięto przycisk" 
						  message:[NSString stringWithFormat: 
								   @"Naciśnięto przycisk %@", buttonTitle] 
						  delegate:nil 
						  cancelButtonTitle:@"OK" 
						  otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
} 

- (void)viewDidLoad { 
    NSArray *array = [[NSArray alloc] initWithObjects:@"R2-D2", 
					  @"C3PO", @"Tik-Tok", @"Robby", @"Rosie", @"Uniblab", 
					  @"Bender", @"Marvin", @"Lt. Commander Data", 
					  @"Evil Brother Lore", @"Optimus Prime", @"Tobor", @"HAL", 
					  @"Orgasmatron", nil]; 
    self.list = array; 
    [array release]; 
    [super viewDidLoad]; 
} 

- (void)viewDidUnload { 
    self.list = nil; 
    [super viewDidUnload]; 
} 

- (void)dealloc { 
    [list release]; 
    [super dealloc]; 
} 

#pragma mark - 
#pragma mark Metody źródła danych tabeli 
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return [list count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
         cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
    static NSString *ControlRowIdentifier = @"ControlRowIdentifier"; 
	
    UITableViewCell *cell = [tableView 
							 dequeueReusableCellWithIdentifier:ControlRowIdentifier]; 
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:ControlRowIdentifier] autorelease]; 
        UIImage *buttonUpImage = [UIImage imageNamed:@"button_up.png"]; 
        UIImage *buttonDownImage = [UIImage imageNamed:@"button_down.png"]; 
        UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom]; 
        button.frame = CGRectMake(0.0, 0.0, buttonUpImage.size.width, 
								  buttonUpImage.size.height); 
        [button setBackgroundImage:buttonUpImage 
						  forState:UIControlStateNormal]; 
        [button setBackgroundImage:buttonDownImage 
						  forState:UIControlStateHighlighted]; 
        [button setTitle:@"Naciśnij" forState:UIControlStateNormal]; 
        [button addTarget:self action:@selector(buttonTapped:) 
		 forControlEvents:UIControlEventTouchUpInside]; 
        cell.accessoryView = button; 
    } 
    NSUInteger row = [indexPath row]; 
    NSString *rowTitle = [list objectAtIndex:row]; 
    cell.textLabel.text = rowTitle; 
	
    return cell; 
} 

#pragma mark - 
#pragma mark Metody delegata tabeli 
- (void)tableView:(UITableView *)tableView 
didSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    NSUInteger row = [indexPath row]; 
    NSString *rowTitle = [list objectAtIndex:row]; 
    UIAlertView *alert = [[UIAlertView alloc] 
						  initWithTitle:@"Naciśnięto rekord." 
						  message:[NSString 
								   stringWithFormat:@"Naciśnięto %@.", rowTitle] 
						  delegate:nil 
						  cancelButtonTitle:@"OK" 
						  otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
    [tableView deselectRowAtIndexPath:indexPath animated:YES]; 
} 

@end
